/*
 * Decompiled with CFR 0.152.
 */
package no.statkart.launcher.client;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import no.statkart.launcher.client.InputDialog;
import no.statkart.launcher.client.Konfigurasjonsverdi;
import no.statkart.launcher.client.Parametre;
import no.statkart.launcher.client.StandardOppsett;
import no.statkart.launcher.client.TjenerKontroll;

class Input {
    private final StandardOppsett standard;

    Input(StandardOppsett standard) {
        this.standard = standard;
    }

    Parametre innhentParametre(List<Parametre> tidligereInputParametre) {
        Parametre input;
        TjenerKontroll kontroll = new TjenerKontroll(this.standard);
        Optional<Object> feil = Optional.empty();
        if (!this.visHeap() && !this.visTjener() && (feil = kontroll.utenBrukerPassord(tidligereInputParametre.get(0))).isEmpty()) {
            return tidligereInputParametre.get(0);
        }
        String melding = this.standard.getKonfigurasjon().get(Konfigurasjonsverdi.INPUT_MESSAGE);
        Path iconPath = this.standard.getRot().resolve("login.png");
        do {
            if ((input = new InputDialog().medTittel(this.inputTittel()).medMelding(melding).medIconPath(iconPath).visHeap(this.visHeap()).visTjener(this.visTjener()).visBrukerPassord(this.visBrukerPassord()).medTidligereInputParametre(tidligereInputParametre).medTidligereFeil(feil.orElse(null)).innhentInputParametre()) != null) continue;
            return null;
        } while ((feil = this.visBrukerPassord() ? kontroll.medBrukerPassord(input) : kontroll.utenBrukerPassord(input)).isPresent());
        return input;
    }

    String inputTittel() {
        String tittel = this.standard.getKonfigurasjon().get(Konfigurasjonsverdi.TITLE);
        String versjon = this.standard.getKonfigurasjon().get(Konfigurasjonsverdi.VERSION);
        return versjon == null ? tittel + " (uversjonert)" : tittel + " " + versjon;
    }

    boolean visTjener() {
        return this.standard.getKonfigurasjon().is(Konfigurasjonsverdi.INPUT_SERVER) || this.standard.getKonfigurasjon().get(Konfigurasjonsverdi.DEFAULT_SERVER) == null;
    }

    boolean visBrukerPassord() {
        return this.standard.getKonfigurasjon().is(Konfigurasjonsverdi.INPUT_CREDENTIALS);
    }

    boolean visHeap() {
        return this.standard.getKonfigurasjon().is(Konfigurasjonsverdi.INPUT_HEAP) || this.standard.getKonfigurasjon().get(Konfigurasjonsverdi.DEFAULT_HEAP) == null;
    }
}

